﻿using System;
using System.Collections.Generic;
using System.Linq;
using MVC_App.Validation;

namespace MVC_App.Models
{
	public class Time
	{
		private Time(int hour, int minute)
		{
			Hour = hour;
			Minute = minute;
		}

		public int Hour { get; private set; }
		public int Minute { get; private set; }

		public static Time Build(int minute, int hour)
		{
			if (minute >= 0 && minute <= 60
				&& hour >= 0 && hour <= 24)
			{
				return new Time(hour, minute);
			}
			return null;
		}

		public static Time Build(string timeString)
		{
			var parts = timeString.Split(':');
			if (parts.Length == 2)
			{
				int hour;
				int minute;
				if (Int32.TryParse(parts[0], out hour)
					&& Int32.TryParse(parts[1], out minute))
				{
					return Build(minute, hour);
				}
			}
			return null;
		}
	}

	static class DateTimeEx
	{
		public static DateTime SetTime(this DateTime date, Time time)
		{
			return new DateTime(date.Year, date.Month, date.Day, time.Hour, time.Minute, 0);
		}

		public static DateTime? Build(string datumString)
		{
			DateTime datum;
			if (DateTime.TryParse(datumString, out datum))
			{
				return datum;
			}
			return null;
		}
	}

	public class GetränkSorteRepository
	{
		public static IEnumerable<GetränkSorteModel> All
		{
			get
			{
				return new[]
				       	{
				       		new GetränkSorteModel("Wasser", new[] {3, 10, 15}),
				       		new GetränkSorteModel("Kaffee", new[] {3, 5}),
				       		new GetränkSorteModel("Apfelsaft", new[] {5, 10})
				       	};
			}
		}

		public static GetränkSorteModel Find(string name)
		{
			return All.SingleOrDefault(it => it.Name == name);
		}
	}

	public class PizzaRepository
	{
		public static IEnumerable<string> Sorten
		{
			get { return new[] { "Napoli", "Salami", "Funghi", "Speziale", "Quattro Formaggi", "Calzone", "Hawaii" }; }
		}
	}

	public class KreditkarteServiceGateway
	{
		public static KreditkarteZahlungModel CheckValidity(string name, string nummer, DateTime gültigBis)
		{
			if (name.StartsWith("Invisible"))
				throw new ValidationException(string.Format("Die Person {0} ist nicht bekannt", name));

			if (nummer.StartsWith("007"))
				throw new ValidationException("Bonität nicht gewährleistet");

			return new KreditkarteZahlungModel { Name = name, Nummer = nummer, GültigBis = gültigBis, Bonität = "hoch" };
		}
	}
}